package gov.va.vinci.dart.db.mock;

import java.util.HashMap;

import gov.va.vinci.dart.biz.Narrative;
import gov.va.vinci.dart.db.NarrativeDAO;

public class NarrativeDAOMock implements NarrativeDAO {
	
	private static final HashMap<Integer,Narrative> IDHash = new HashMap<Integer,Narrative>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(Narrative narrative) {
		if (narrative == null) {
			throw new IllegalArgumentException();
		}
		
		initializeNarrativeHash();
		
		if (narrative.getId() == 0) {
			narrative.setId(idCounter++);
		}
		
		IDHash.put(narrative.getId(), narrative);
	}

	@Override
	public Narrative findById(int narrativeId) {
		initializeNarrativeHash();
		
		return IDHash.get(narrativeId);
	}

	private void initializeNarrativeHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
	}

}
